package com.bitbof.escape.entities;

import org.lwjgl.examples.spaceinvaders.Texture;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

import com.bitbof.escape.Art;

public class GravityElasticHook implements Entity, Hook {
	
	public World world;
	public int MAX_HEALTH = 400;
	public Vector2f startpos = new Vector2f(0, 0);
	public Vector2f pos = new Vector2f(startpos);
	public float radius = 10;
	public boolean alive = true;
	public int hookHealth = 0;
	public ElasticBand attachedBand;
	public float vy = 0;
	
	@Override
	public void tick() {
		if(hookHealth > 0) {
			hookHealth--;
		}
		else {
			attachedBand = null;
		}
		if(attachedBand != null) {
			vy -= .1f;
			if(vy < -1)
				vy = -1;
			pos.y += vy;
		} else {
			vy += (startpos.y - pos.y)*0.01;
			pos.y += vy;
			vy *= 0.5;
		}
	}

	@Override
	public void render() {
		if(!alive)
			return;
		GL11.glPushMatrix();
		Art.ball.bind();
		Texture texture = Art.ball;
		GL11.glColor4f(0, (hookHealth/(float)MAX_HEALTH), (hookHealth/(float)MAX_HEALTH), 1);
		GL11.glTranslatef(pos.x, pos.y, 0);
		GL11.glRotatef(1, 0, 0, 0);

		GL11.glScalef(radius*2, radius*2 , 0);
		GL11.glBegin(GL11.GL_QUADS);
		GL11.glTexCoord2f(0, 0);
		GL11.glVertex2f(-0.5f, -0.5f);
		GL11.glTexCoord2f(0, texture.getHeight());
		GL11.glVertex2f(0.5f, -0.5f);
		GL11.glTexCoord2f(texture.getWidth(), texture.getHeight());
		GL11.glVertex2f(0.5f, 0.5f);
		GL11.glTexCoord2f(texture.getWidth(), 0);
		GL11.glVertex2f(-0.5f, 0.5f);
		GL11.glEnd();
		GL11.glPopMatrix();
	}

	@Override
	public boolean isAlive() {
		return alive;
	}

	@Override
	public void attachBand(ElasticBand band) {
		if(attachedBand != null)
			return;
		attachedBand = band;
		hookHealth = MAX_HEALTH;
	}

	@Override
	public boolean isBandAttached() {
		return attachedBand != null;
	}

	@Override
	public Vector2f getPos() {
		return new Vector2f(pos);
	}

	@Override
	public float getHealth() {
		return hookHealth/(float)MAX_HEALTH;
	}

	@Override
	public ElasticBand getAttachedBand() {
		return attachedBand;
	}

	@Override
	public float getRadius() {
		return radius;
	}

}
